package myBean;

import java.io.*;
import java.util.*;
import javax.imageio.*;
import java.awt.*;
import java.awt.image.*;

public class Histogram {
	public Histogram() {
	}
	
	public double getHistogram(int width, int totalWidth, int height, OutputStream os) {
		
		if(width>totalWidth)
			return 0;
		
		BufferedImage image = new BufferedImage(totalWidth, height, 
									BufferedImage.TYPE_INT_RGB); 

		// ȡͼ 
		Graphics g = image.getGraphics(); 

		// 趨ɫ 
		g.setColor(new Color(0xFDFDFD)); 
		g.fillRect(0, 0, totalWidth, height); 

		// ߿ 
		g.setColor(Color.black); 
		g.drawRect(0,0,totalWidth-1,height-1);

		// ״ͼ
		g.setColor(Color.blue);
		g.fillRect(0, 0, width, height);
		

		// ͷͼ
		g.dispose(); 
		
		try {
			// ͼҳ 
			ImageIO.write(image, "JPEG", os);
		} catch (IOException e) {
			return 0;
		}
		
		return (double)width/totalWidth;
	}

/*	
	public static void main(String []args) {
		try{
			BufferedOutputStream os = new BufferedOutputStream(
											new FileOutputStream("c:\\test.jpg"));
											
			new Histogram().getHistogram(180, 200, 20, os);
			os.flush();
			os.close();
		} catch(Exception e) {}
	}
*/
}